<?php
include('sabitsayfalar/header.php');
?>



<section id="section-teknolojik" class="section-dark no-top no-bottom text-light jarallax relative mh-500 jarallax">
    <img src="images/background/3.webp" class="jarallax-img" alt="">
    <div class="gradient-edge-bottom h-50"></div>
    <div class="sw-overlay op-5"></div>
    <div class="abs bottom-10 z-2 w-100">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-10">
                    <h1 class="text-start fs-48 fs-sm-10vw wow fadeIn" data-wow-delay=".6s">
                        Teknolojik Talep Başvurusu
                    </h1>

                </div>
            </div>
        </div>
    </div>
</section>
<section id="section-teknolojik-form">
    <div class="container">
        <div class="row g-4 justify-content-center">
            <div class="col-lg-10">
                <div class="blog-read">

                    <div class="post-text">

                        <img src="images/misc/2.png" class="w-100 rounded-1 mb-4" alt="">
                        <p>İşletmelerinizin karşılaştığı dijital dönüşüm odaklı ihtiyaçlarınızı ve teknolojik sorunlarınızı bizimle paylaşın. İster üretim hattınızda ister veri yönetiminizde çözüm bekleyen bir konu olsun, Dijital Hamle uzman ağı ile size özel çözüm modelleri sunabilir. Teknolojik Talep Başvurusu üzerinden ilettiğiniz ihtiyaçlar, girişimciler, mühendis ekipler ve çözüm ortaklarımızla eşleştirilerek dönüşüm sürecinize katkı sağlanır.</p>
                    </div>

                </div>

                <div class="spacer-single"></div>

                <div id="blog-comment-teknolojik">
                    <h4>Talep Başvurusu Formu</h4>

                    <div class="spacer-half"></div>

                    <div class="spacer-single"></div>

                    <div id="comment-form-wrapper-teknolojik">
                        <div class="comment_form_holder">
                            <?php
                            if ($_SERVER["REQUEST_METHOD"] === "POST") {
                                include("baglanti.php"); // PDO bağlantı dosyan

                                // Form verilerini al
                                $talep_ad = $_POST['talep_ad'] ?? '';
                                $talep_soyad = $_POST['talep_soyad'] ?? '';
                                $talep_email = $_POST['talep_email'] ?? '';
                                $talep_telefon = $_POST['talep_telefon'] ?? '';
                                $talep_firma_adi = $_POST['talep_firma_adi'] ?? '';
                                $talep_faaliyet_alani = $_POST['talep_faaliyet_alani'] ?? '';
                                $talep_edilen_cozum = $_POST['talep_edilen_cozum'] ?? '';
                                $talep_mevcut_altyapi = $_POST['talep_mevcut_altyapi'] ?? '';
                                $talep_hedefler_beklentiler = $_POST['talep_hedefler_beklentiler'] ?? '';
                                $talep_zaman_cizelgesi = $_POST['talep_zaman_cizelgesi'] ?? '';
                                $talep_proje_butcesi = $_POST['talep_proje_butcesi'] ?? '';
                                $talep_destek_ihtiyaclari = $_POST['talep_destek_ihtiyaclari'] ?? '';

                                // Dosya işlemleri
                                $dosyaAdi = null;
                                $dosyaUzantisi = null;
                                $dosyaYolu = null;

                                if (isset($_FILES['dosya']) && $_FILES['dosya']['error'] === UPLOAD_ERR_OK) {
                                    $dosyaBoyutu = $_FILES['dosya']['size'];
                                    $maxBoyut = 2 * 1024 * 1024; // 5MB

                                    $orjinalAd = $_FILES['dosya']['name'];
                                    $dosyaUzantisi = strtolower(pathinfo($orjinalAd, PATHINFO_EXTENSION));

                                    $izinliUzantilar = ['pdf', 'doc', 'docx', 'zip', 'rar'];

                                    if (!in_array($dosyaUzantisi, $izinliUzantilar)) {
                                        echo '<div class="alert alert-warning">Yalnızca pdf, doc, docx, zip ve rar uzantılı dosyalar yüklenebilir.</div>';
                                    } elseif ($dosyaBoyutu > $maxBoyut) {
                                        echo '<div class="alert alert-warning">Dosya boyutu 5MB\'dan büyük olamaz.</div>';
                                    } else {
                                        $dosyaAdi = uniqid('girisimci_') . '.' . $dosyaUzantisi;

                                        // Klasör yolu - senin sistemine göre
                                        $yuklemeKlasoru = $dosya_path . '/upload-teknologicalrequest/';
                                        if (!is_dir($yuklemeKlasoru)) {
                                            mkdir($yuklemeKlasoru, 0777, true);
                                        }

                                        $dosyaYolu = $yuklemeKlasoru . $dosyaAdi;
                                        $veritabaniYolu = '/upload-teknologicalrequest/' . $dosyaAdi;

                                        if (!move_uploaded_file($_FILES['dosya']['tmp_name'], $dosyaYolu)) {
                                            echo '<div class="alert alert-danger">Dosya yükleme sırasında bir hata oluştu.</div>';
                                            $dosyaAdi = $dosyaUzantisi = $veritabaniYolu = null;
                                        }
                                    }
                                }


                                // Veritabanına kayıt
                                $sorgu = $connPDO->prepare("
        INSERT INTO teknolojik_talep_basvuru (
            talep_ad, talep_soyad, talep_email, talep_telefon, talep_firma_adi,
            talep_faaliyet_alani, talep_edilen_cozum, talep_mevcut_altyapi,
            talep_hedefler_beklentiler, talep_zaman_cizelgesi, talep_proje_butcesi,
            talep_destek_ihtiyaclari, dosya_adi, dosya_uzantisi, dosya_yolu
        ) VALUES (
            :ad, :soyad, :email, :telefon, :firma_adi,
            :faaliyet_alani, :edilen_cozum, :mevcut_altyapi,
            :hedefler_beklentiler, :zaman_cizelgesi, :proje_butcesi,
            :destek_ihtiyaclari, :dosya_adi, :dosya_uzantisi, :dosya_yolu
        )
    ");

                                $sorgu->execute([
                                    ':ad' => $talep_ad,
                                    ':soyad' => $talep_soyad,
                                    ':email' => $talep_email,
                                    ':telefon' => $talep_telefon,
                                    ':firma_adi' => $talep_firma_adi,
                                    ':faaliyet_alani' => $talep_faaliyet_alani,
                                    ':edilen_cozum' => $talep_edilen_cozum,
                                    ':mevcut_altyapi' => $talep_mevcut_altyapi,
                                    ':hedefler_beklentiler' => $talep_hedefler_beklentiler,
                                    ':zaman_cizelgesi' => $talep_zaman_cizelgesi,
                                    ':proje_butcesi' => $talep_proje_butcesi,
                                    ':destek_ihtiyaclari' => $talep_destek_ihtiyaclari,
                                    ':dosya_adi' => $dosyaAdi,
                                    ':dosya_uzantisi' => $dosyaUzantisi,
                                    ':dosya_yolu' => $veritabaniYolu ?? null
                                ]);

                                echo '<div class="alert alert-success">Başvurunuz başarıyla kaydedildi.</div>';
                            }
                            ?>


                            <form action="" method="POST" enctype="multipart/form-data" class="form-border">

                            <p class="mb-3"><span class="text-danger">*</span> ile işaretli alanların doldurulması zorunludur.</p>

                                <div class="row g-4">
                                    <div class="col-md-6">
                                        <label>Ad <span class="text-danger">*</span></label>
                                        <input type="text" name="talep_ad" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Soyad <span class="text-danger">*</span></label>
                                        <input type="text" name="talep_soyad" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Email <span class="text-danger">*</span></label>
                                        <input type="email" name="talep_email" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Telefon <span class="text-danger">*</span></label>
                                        <input type="text" name="talep_telefon" id="telefon" class="form-control" required placeholder="0555 489 75 48" pattern="05\d{2} \d{3} \d{2} \d{2}">
                                    </div>
                                    <div class="col-md-6">
                                        <label>Firma Adı <span class="text-danger">*</span></label>
                                        <input type="text" name="talep_firma_adi" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Faaliyet Alanı <span class="text-danger">*</span></label>
                                        <input type="text" name="talep_faaliyet_alani" class="form-control" maxlength="255" required>
                                    </div>
                                    <div class="col-12">
                                        <label>Talep Edilen Teknolojik Çözüm <span class="text-danger">*</span></label>
                                        <textarea name="talep_edilen_cozum" class="form-control" rows="3" required></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label>Mevcut Altyapınız <span class="text-danger">*</span></label>
                                        <textarea name="talep_mevcut_altyapi" class="form-control" rows="3" required></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label>Hedefler ve Beklentiler <span class="text-danger">*</span></label>
                                        <textarea name="talep_hedefler_beklentiler" class="form-control" rows="3" required></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label>Zaman Çizelgesi <span class="text-danger">*</span></label>
                                        <textarea name="talep_zaman_cizelgesi" class="form-control" rows="2" required></textarea>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Proje Bütçesi <span class="text-danger">*</span></label>
                                        <input type="text" name="talep_proje_butcesi" class="form-control" required>
                                    </div>
                                    <div class="col-12">
                                        <label>Destek İhtiyaçları <span class="text-danger">*</span></label>
                                        <textarea name="talep_destek_ihtiyaclari" class="form-control" rows="3" required></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label>Dosya Yükle</label>
                                        <input type="file" name="dosya" class="form-control" accept=".pdf,.doc,.docx,.zip,.rar" style="background-color: #fff; color: #000;">
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn-main fx-slide"><span>Başvuruyu Gönder</span></button>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
</section>



<?php
include('sabitsayfalar/footer.php');
?>

<script>
    <?php /*  SAYFAYA ÖZEL JS KODLARI BURAYA YAZILACAK */ ?>
</script>