<?php
include('sabitsayfalar/header.php');
?>


    <section id="section-hero" class="section-dark no-top no-bottom text-light jarallax relative mh-500 jarallax">
        <img src="images/background/3.webp" class="jarallax-img" alt="">
        <div class="gradient-edge-bottom h-50"></div>
        <div class="sw-overlay op-5"></div>
        <div class="abs w-80 bottom-10 z-2 w-100">
            <div class="container">
                <div class="row align-items-center justify-content-between gx-5">
                    <div class="col-lg-6">
                        <div class="relative wow mask-right">
                            <div class="text-start">
                                <h1 class="fs-96  fs-sm-10vw mb-0 lh-1">İştirakler</h1>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 wow fadeInRight" data-wow-delay=".3s">
                        <p class="mb-0" style="text-align: justify;">


                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php
$istirak_onay = 1;
$kayit_sayisi = 9;

// Sayfa kontrolü
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$sayfa = max($sayfa, 1);
$baslangic = ($sayfa - 1) * $kayit_sayisi;

// Toplam kayıt sayısı
$sorgu_toplam = "SELECT COUNT(*) as toplam FROM istirakler 
                 INNER JOIN istirak_dil ON istirak_id = istirakdil_istirak_id 
                 WHERE istirak_onay = :onay AND istirak_userfirm_id = :basekayit";
$stmt_toplam = $connPDO->prepare($sorgu_toplam);
$stmt_toplam->bindParam(':onay', $istirak_onay, PDO::PARAM_INT);
$stmt_toplam->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
$stmt_toplam->execute();
$toplam_kayit = $stmt_toplam->fetch(PDO::FETCH_ASSOC)['toplam'];
$toplam_sayfa = ceil($toplam_kayit / $kayit_sayisi);

// Asıl veriyi çek
$sorgu = "SELECT * FROM istirakler 
          INNER JOIN istirak_dil ON istirak_id = istirakdil_istirak_id 
          WHERE istirak_onay = :onay AND istirak_userfirm_id = :basekayit 
          ORDER BY istirak_eklenme_tarihi DESC 
          LIMIT :baslangic, :limit";
$stmt = $connPDO->prepare($sorgu);
$stmt->bindParam(':onay', $istirak_onay, PDO::PARAM_INT);
$stmt->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
$stmt->bindParam(':baslangic', $baslangic, PDO::PARAM_INT);
$stmt->bindParam(':limit', $kayit_sayisi, PDO::PARAM_INT);
$stmt->execute();
?>

    <section>
        <div class="container">
            <div class="row g-4">
                <?php
                $aylar = ['01'=>'Ocak','02'=>'Şubat','03'=>'Mart','04'=>'Nisan','05'=>'Mayıs','06'=>'Haziran',
                    '07'=>'Temmuz','08'=>'Ağustos','09'=>'Eylül','10'=>'Ekim','11'=>'Kasım','12'=>'Aralık'];

                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    $tarih = new DateTime($row['istirak_eklenme_tarihi']);
                    $gun = $tarih->format('d');
                    $ay = $aylar[$tarih->format('m')];
                    $istirak_resim = $row['istirak_resim'];
                    $resim_path = '/upload-oursubsidiaries/' . $base_firm_id . '/' . $istirak_resim ;
                    $gercek_yol = $dosya_path . $resim_path;
                    $resimYolu = (!empty($row['istirak_resim']) && file_exists($gercek_yol))
                        ? $dosya_url . $resim_path
                        : $base_url . 'images/news/s1.webp';
                    $detayUrl = $base_url . $row['istirakdil_sayfaurl'];
                    ?>
                    <div class="col-lg-4">
                        <a href="<?php echo $detayUrl; ?>" class="d-block hover relative rounded-20 overflow-hidden text-light">
                            <div class="abs z-2 bg-color rounded-2 text-white p-3 pb-2 m-4 text-center fw-600">
                                <h4 class="fs-36 mb-0 lh-1"><?php echo $gun; ?></h4>
                                <span><?php echo $ay; ?></span>
                            </div>
                            <img src="<?php echo $resimYolu; ?>" class="w-100 hover-scale-1-1" alt="">
                            <div class="absolute start-0 bottom-0 p-4 z-2">
                                <h4><?php echo $row['istirakdil_sayfaad']; ?></h4>
                            </div>
                            <div class="gradient-edge-bottom h-70"></div>
                        </a>
                    </div>
                <?php } ?>
                <div class="col-lg-12 pt-4 text-center">
                    <div class="d-inline-block">
                        <nav aria-label="Page navigation">
                            <ul class="pagination">
                                <?php if ($sayfa > 1): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?sayfa=<?php echo $sayfa - 1; ?>" aria-label="Previous">
                                            <span><i class="fa fa-chevron-left"></i></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php for ($i = 1; $i <= $toplam_sayfa; $i++): ?>
                                    <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                                        <a class="page-link" href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                                    </li>
                                <?php endfor; ?>
                                <?php if ($sayfa < $toplam_sayfa): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?sayfa=<?php echo $sayfa + 1; ?>" aria-label="Next">
                                            <span><i class="fa fa-chevron-right"></i></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>



<?php
include('sabitsayfalar/footer.php');
?>