<?php
include('sabitsayfalar/header.php');
?>

    <section id="section-hero" class="section-dark no-top no-bottom text-light jarallax relative mh-500 jarallax">
        <img src="images/background/3.webp" class="jarallax-img" alt="">
        <div class="gradient-edge-bottom h-50"></div>
        <div class="sw-overlay op-5"></div>
        <div class="abs w-80 bottom-10 z-2 w-100">
            <div class="container">
                <div class="row align-items-center justify-content-between gx-5">
                    <div class="col-lg-6">
                        <div class="relative wow mask-right">
                            <div class="text-start">
                                <h1 class="fs-96 text-uppercase fs-sm-10vw mb-0 lh-1">Duyurular</h1>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 wow fadeInRight" data-wow-delay=".3s">
                        <p class="mb-0">Yapay zekadan dijital dönüşüme, tarımdan sağlığa birçok alandaki yenilikçi adımları buradan takip edebilirsiniz. Duyurularımızla ilham verici gelişmeleri kaçırmayın.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php
$duyuru_onay = 1;
$kayit_sayisi = 9;

// Sayfa kontrolü
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$sayfa = max($sayfa, 1);
$baslangic = ($sayfa - 1) * $kayit_sayisi;

// Toplam kayıt sayısı
$sorgu_toplam = "SELECT COUNT(*) as toplam FROM duyurular 
                 INNER JOIN duyuru_dil ON duyuru_id = duyurudil_duyuru_id 
                 WHERE duyuru_onay = :onay";
$stmt_toplam = $connPDO->prepare($sorgu_toplam);
$stmt_toplam->bindParam(':onay', $duyuru_onay, PDO::PARAM_INT);
$stmt_toplam->execute();
$toplam_kayit = $stmt_toplam->fetch(PDO::FETCH_ASSOC)['toplam'];
$toplam_sayfa = ceil($toplam_kayit / $kayit_sayisi);

// Asıl duyuru çekme sorgusu
$sorgu = "SELECT * FROM duyurular 
          INNER JOIN duyuru_dil ON duyuru_id = duyurudil_duyuru_id 
          INNER JOIN userfirm ON duyuru_userfirm_id = userfirm_id 
          WHERE duyuru_onay = :onay 
          AND duyuru_userfirm_id = :basekayit
          ORDER BY duyuru_eklenme_tarihi DESC 
          LIMIT :baslangic, :limit";
$stmt = $connPDO->prepare($sorgu);
$stmt->bindParam(':onay', $duyuru_onay, PDO::PARAM_INT);
$stmt->bindParam(':baslangic', $baslangic, PDO::PARAM_INT);
$stmt->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
$stmt->bindParam(':limit', $kayit_sayisi, PDO::PARAM_INT);
$stmt->execute();
?>
    <section>
    <div class="container">
    <div class="row g-4">
<?php
$aylar = ['01'=>'Ocak','02'=>'Şubat','03'=>'Mart','04'=>'Nisan','05'=>'Mayıs','06'=>'Haziran',
    '07'=>'Temmuz','08'=>'Ağustos','09'=>'Eylül','10'=>'Ekim','11'=>'Kasım','12'=>'Aralık'];

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $tarih = new DateTime($row['duyuru_eklenme_tarihi']);
    $gun = $tarih->format('d');
    $ay = $aylar[$tarih->format('m')];
    $duyuru_resim = $row['duyuru_resim'];
    $resim_path = "upload-notice/{$row['userfirm_id']}/detail/{$duyuru_resim}";
    if (empty($duyuru_resim) || !file_exists(__DIR__ . '/' . $resim_path)) {
        $resimYolu = 'images/news/s1.webp';
    } else {
        $resimYolu = $dosya_url . $resim_path;
    }
    $detayUrl = $base_url . $row['duyurudil_sayfaurl'];
    ?>
    <div class="col-lg-4">
        <a href="<?php echo $detayUrl; ?>" class="d-block hover relative rounded-20 overflow-hidden text-light">
            <div class="abs z-2 bg-color rounded-2 text-white p-3 pb-2 m-4 text-center fw-600">
                <h4 class="fs-36 mb-0 lh-1"><?php echo $gun; ?></h4>
                <span><?php echo $ay; ?></span>
            </div>
            <img src="<?php echo $resimYolu; ?>" class="w-100 hover-scale-1-1" alt="">
            <div class="absolute start-0 bottom-0 p-4 z-2">
                <h4><?php echo $row['duyurudil_sayfaad']; ?></h4>
            </div>
            <div class="gradient-edge-bottom h-70"></div>
        </a>
    </div>
<?php } ?>
        <div class="col-lg-12 pt-4 text-center">
            <div class="d-inline-block">
                <nav aria-label="Page navigation">
                    <ul class="pagination">
                        <?php if ($sayfa > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="?sayfa=<?php echo $sayfa - 1; ?>" aria-label="Previous">
                                    <span><i class="fa fa-chevron-left"></i></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php for ($i = 1; $i <= $toplam_sayfa; $i++): ?>
                            <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                                <a class="page-link" href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                            </li>
                        <?php endfor; ?>
                        <?php if ($sayfa < $toplam_sayfa): ?>
                            <li class="page-item">
                                <a class="page-link" href="?sayfa=<?php echo $sayfa + 1; ?>" aria-label="Next">
                                    <span><i class="fa fa-chevron-right"></i></span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
        </div>
    </div>
    </div>
    </section>



<?php
include('sabitsayfalar/footer.php');
?>