
<?php
include('sabitsayfalar/header.php');
?>

<section id="section-hero" class="section-dark text-light p-0 relative overflow-hidden z-1000">
    <div class="mh-800">
        <div class="swiper">
            <div class="swiper-wrapper">

                <!-- Slide 1 -->
                <div class="swiper-slide position-relative">
                    <div class="swiper-inner">
                        <video class="video-bg" autoplay muted loop playsinline>
                            <source src="video/DH Portal - 02 Dijital Dönüşüm Burada Başlar.mp4" type="video/mp4">
                        </video>
                        <div class="sw-overlay op-6"></div>
                        <div class="gradient-edge-bottom"></div>
                    </div>
                    <div class="overlay-content abs abs-centered z-2 text-center text-light">
                        <h2>İşletmeler İçin Dijital Geleceğe Güçlü Bir Hamle</h2>
                        <p>Dijital Hamle Dönüşüm Merkezi; KOBİ’lere ve sanayi işletmelerine özel dijital analiz, yol haritası, teknoloji danışmanlığı ve uygulama desteği sunarak dijitalleşme süreçlerini hızlandırır ve rekabet güçlerini artırır.</p>

                    </div>
                </div>

                <!-- Slide 2 -->
                <div class="swiper-slide position-relative">
                    <div class="swiper-inner">
                        <video class="video-bg" autoplay muted loop playsinline>
                            <source src="video/DH Portal - 03 Fikirden Geleceğe Dijital Hamle Girişimcilik Merkezi.mp4" type="video/mp4">
                        </video>
                        <div class="sw-overlay op-6"></div>
                        <div class="gradient-edge-bottom"></div>
                    </div>
                    <div class="overlay-content abs abs-centered z-2 text-center text-light">
                        <h2>Girişimcilik ve Büyümenin Yeni Adresi</h2>
                        <p>Zirve Girişim Merkezi; girişimcilere, yenilikçi fikirlere ve büyümek isteyen işletmelere mentorluk, eğitim, ağ kurma ve yatırım destekleri sunan kapsamlı bir inovasyon ve iş geliştirme platformudur.</p>

                    </div>
                </div>

                <!-- Slide 3 -->
                <div class="swiper-slide position-relative">
                    <div class="swiper-inner">
                        <video class="video-bg" autoplay muted loop playsinline>
                            <source src="video/DH Portal - 04 Fikirlerin Buluştuğu, Geleceğin İnşa Edildiği Alan.mp4" type="video/mp4">
                        </video>
                        <div class="sw-overlay op-6"></div>
                        <div class="gradient-edge-bottom"></div>
                    </div>
                    <div class="overlay-content abs abs-centered z-2 text-center text-light">
                        <h2>Çalışmanın En Özgür ve Üretken Hali</h2>
                        <p>Zirve Açık Ofis;  çalışanlara ve girişimcilere esnek çalışma alanları, yüksek hızlı internet, toplantı odaları ve ilham verici bir topluluk sunan modern bir ortak çalışma alanıdır.</p>

                    </div>
                </div>

                <!-- Slide 4 -->
                <div class="swiper-slide position-relative">
                    <div class="swiper-inner">
                        <video class="video-bg" autoplay muted loop playsinline>
                            <source src="video/DH Portal - 01.mp4" type="video/mp4">
                        </video>
                        <div class="sw-overlay op-6"></div>
                        <div class="gradient-edge-bottom"></div>
                    </div>
                    <div class="overlay-content abs abs-centered z-2 text-center text-light">
                        <h2>Geleceği Dönüştüren Eğitim Platformu</h2>
                        <p>Dijital Dönüşüm Akademisi; işletmelerin ve bireylerin dijital çağa uyum sağlaması için eğitim, danışmanlık ve uygulamalı atölyeler sunan yenilikçi bir öğrenme ve gelişim merkezidi</p>
                    </div>
                </div>

            </div>

            <!-- Navigasyon -->
            <div class="swiper-pagination"></div>
            <div class="swiper-button-prev"></div>
            <div class="swiper-button-next"></div>
        </div>
    </div>
</section>


<section id="section-etkinlikler" class="bg-dark section-dark text-light">
    <div class="container">
        <div class="row gx-5 align-items-center justify-content-between">
            <div class="col-lg-6">
                <div class="me-lg-5 pe-lg-5 py-5 my-5">
                    <div class="subtitle wow fadeInUp" data-wow-delay=".2s">Yaklaşan Etkinlikler</div>
                    <h2 class="wow fadeInUp" data-wow-delay=".4s">Duyurular</h2>

                    <?php
                    $duyuru_onay = 1;

                    $sorgu = "SELECT * FROM duyurular 
    INNER JOIN duyuru_dil ON duyuru_id = duyurudil_duyuru_id 
    WHERE duyuru_onay = :duyuru_onay 
      AND duyuru_userfirm_id = :basekayit
    ORDER BY duyuru_eklenme_tarihi DESC 
    LIMIT 3";

                    $stmt = $connPDO->prepare($sorgu);
                    $stmt->bindParam(':duyuru_onay', $duyuru_onay, PDO::PARAM_INT);
                    $stmt->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
                    $stmt->execute();

                    $aylar = [
                        '01' => 'Ocak', '02' => 'Şubat', '03' => 'Mart', '04' => 'Nisan',
                        '05' => 'Mayıs', '06' => 'Haziran', '07' => 'Temmuz', '08' => 'Ağustos',
                        '09' => 'Eylül', '10' => 'Ekim', '11' => 'Kasım', '12' => 'Aralık'
                    ];

                    if ($stmt->rowCount() > 0) {
                        $delay = 0.6;
                        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                            $tarih = new DateTime($row['duyuru_eklenme_tarihi']);
                            $formatliTarih = $tarih->format('d') . ' ' . $aylar[$tarih->format('m')] . ' ' . $tarih->format('Y');
                            ?>
                            <div class="event-box wow fadeInUp" data-wow-delay="<?php echo $delay . 's'; ?>">
                                <a href="<?php echo $base_url . $row['duyurudil_sayfaurl']; ?>" style="text-decoration: none; color: inherit;">
                                    <h4><?php echo $row['duyurudil_sayfaad']; ?></h4>
                                    <p><?php echo mb_substr(strip_tags($row['duyurudil_metni']), 0, 150) . '...'; ?></p>
                                    <small><i class="fa fa-calendar me-2"></i><?php echo $formatliTarih; ?></small>
                                </a>
                            </div>
                            <?php
                            $delay += 0.1;
                        }
                    } else {
                        echo "<p class='text-light'>Henüz etkinlik duyurusu yok.</p>";
                    }
                    ?>

                    <!-- Tüm Etkinlikler Butonu -->
                    <div class="mt-4 wow fadeInUp" data-wow-delay="1s">
                        <a href="<?php echo $base_url . 'duyurular'; ?>" class="btn-main btn-line">
                            Tüm Etkinlikleri Gör
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-5">
                <div class="wow scaleIn">
                    <img src="images/misc/c1.webp" class="w-100 rotate-animation" alt="">
                </div>
            </div>
        </div>
    </div>
</section>



<section class="section-dark p-0" aria-label="section">
    <div class="bg-color text-light d-flex py-4 lh-1 rot-2">
        <div class="de-marquee-list-1 wow fadeInLeft" data-wow-duration="3s">
            <span class="fs-60 mx-3">Odak</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Sistem Kys</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Karbon Kare</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Dijital Dönüşüm Akademisi</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Hürsat</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Zirve Girişim Merkezi</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Zirve Açık Ofis</span>
            <span class="fs-60 mx-3 op-2">/</span>
        </div>
    </div>

    <div class="bg-color-2 text-light d-flex py-4 lh-1 rot-min-1 mt-min-20">
        <div class="de-marquee-list-2 wow fadeInRight" data-wow-duration="3s">
            <span class="fs-60 mx-3">Odak</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Sistem Kys</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Karbon Kare</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Dijital Dönüşüm Akademisi</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Hürsat</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Zirve Girişim Merkezi</span>
            <span class="fs-60 mx-3 op-2">/</span>
            <span class="fs-60 mx-3">Zirve Açık Ofis</span>
            <span class="fs-60 mx-3 op-2">/</span>
        </div>
    </div>
</section>

<?php
$egitim_onay = 1;
$limit = 6;

$sorgu_egitim = "SELECT * FROM egitimler 
                 INNER JOIN egitim_dil ON egitim_id = egitimdil_egitim_id 
                 WHERE egitim_onay = :onay 
                   AND egitim_userfirm_id = :basekayit
                 ORDER BY egitim_eklenme_tarihi DESC
                 LIMIT :limit";

$stmt = $connPDO->prepare($sorgu_egitim);
$stmt->bindParam(':onay', $egitim_onay, PDO::PARAM_INT);
$stmt->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
$stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
$stmt->execute();

$egitimler = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<section id="section-why-egitimler" class="bg-dark section-dark text-light">
    <div class="container">
        <div class="row g-4">
            <div class="col-lg-6 offset-lg-3 text-center">
                <h2 class="wow fadeInUp" data-wow-delay=".2s">Eğitimlerimiz</h2>
                <p class="lead mb-0 wow fadeInUp">Eğitimlerle kendinizi geliştirmek ister misiniz?</p>
            </div>
        </div>

        <div class="spacer-single"></div>

        <?php if (!empty($egitimler)): ?>
            <div class="row g-4">
                <?php foreach ($egitimler as $row):
                    $resim_path = '/upload-trainings/' . $base_firm_id . '/' . $row['egitim_resim'];
                    $gercek_yol = $dosya_path . $resim_path;

                    $resimYolu = (!empty($row['egitim_resim']) && file_exists($gercek_yol))
                        ? $dosya_url . $resim_path
                        : $base_url . 'images/news/s1.webp';

                    $detayUrl = $base_url . $row['egitimdil_sayfaurl'];
                    ?>
                    <div class="col-lg-4 col-md-6">
                        <a href="<?= htmlspecialchars($detayUrl) ?>" class="hover d-block text-light">
                            <div class="bg-dark-2 relative rounded-1 overflow-hidden hover-bg-color hover-text-light wow scale-in-mask">
                                <div class="abs p-40 bottom-0 z-2">
                                    <div class="relative wow fadeInUp">
                                        <h4><?= htmlspecialchars($row['egitimdil_sayfaad']) ?></h4>
                                        <p class="mb-0"><?= mb_substr(strip_tags($row['egitimdil_metni']), 0, 100) ?>...</p>
                                    </div>
                                </div>
                                <div class="gradient-edge-bottom h-100"></div>
                                <div class="w-100 hover-scale-1-1 bg-image"
                                     style="height: 250px; background-image: url('<?= htmlspecialchars($resimYolu) ?>'); background-size: cover; background-position: center;">
                                </div>
                                <div class="abs w-100 h-100 start-0 top-0 hover-op-1 radial-gradient-color"></div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="text-center mt-5 wow fadeInUp" data-wow-delay="1s">
                <a href="<?= $base_url ?>egitimler" class="btn-main btn-line">
                    Tüm Eğitimleri Gör
                </a>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <img src="<?= $base_url ?>images/coming-soon.webp" alt="Eğitimlerimiz yakında burada olacak" class="img-fluid mb-4" style="max-width:300px;">
                <h4>Eğitimlerimiz çok yakında burada yer alacaktır.</h4>
            </div>
        <?php endif; ?>
    </div>
</section>





<section class="bg-dark section-dark text-light pt-80 relative jarallax" aria-label="section">
    <img src="images/background/2.webp" class="jarallax-img" alt="">
    <div class="gradient-edge-top"></div>
    <div class="gradient-edge-bottom"></div>
    <div class="sw-overlay op-8"></div>
    <div class="container relative z-4">
        <div class="row align-items-center g-5">
            <div class="col-md-4">
                <div class="relative w-100 d-inline-block pe-5">
                    <div class="abs bg-color w-80px h-80px rounded-1 text-center end-0 z-2 wow scaleIn">
                        <i class="icofont-quote-left text-white fs-40 d-block pt-3"></i>
                    </div>
                    <img src="images/misc/1684138403962.jpg" class="w-100 rounded-1 wow scale-in-mask" alt="">
                </div>
            </div>

            <div class="col-md-8">
                <p class="fs-20 mb-4 wow fadeInUp" style="text-align: justify;">
                    “ Dijital Hamle, 2011 yılında başlayan hikayesi ile Türkiye’nin üretim ve sanayi sektöründe dijital dönüşümün öncüsü olma misyonuyla yola çıktı. Biz, sadece teknolojiyi takip eden değil, onu kendi gücüne dönüştüren bir ekosistemin parçasıyız. Değişime açık, yenilikçi ve cesur adımlarla geleceği şekillendiren işletmelerin yanında olmak, onlara yol göstermek bizim en büyük motivasyonumuzdur.Her işletme, Dijital Hamle ile kendi potansiyelini keşfedip, dijital çağın sunduğu fırsatları en etkili şekilde kullanabilir. Bu platformumda, Türkiye’nin dijital geleceğine birlikte hamle yapmaya hazır olan herkes için varız.Dijital Hamle ruhuyla, birlikte ilerlemek dileğiyle,”                </p>
                <span>Ahmet Murat NUHOĞLU</span>
            </div>
        </div>
    </div>
</section>
<section class="position-relative overflow-hidden" style="height: 650px;">
    <!-- Video -->
    <video class="position-absolute top-0 start-0 w-100 h-100 object-fit-cover" autoplay muted loop playsinline>
        <source src="video/DH Banner Partner.mp4" type="video/mp4">
        Tarayıcınız video etiketini desteklemiyor.
    </video>
</section>




<section class="bg-dark section-dark pt-80 relative jarallax" aria-label="section">

    <img src="images/background/1.webp" class="jarallax-img" alt="">
    <div class="gradient-edge-top"></div>
    <div class="gradient-edge-bottom"></div>
    <div class="sw-overlay op-8"></div>
    <div class="container">
        <div class="row g-4">

            <div class="col-md-12 wow fadeInUp">
                <div class="owl-6 no-alpha owl-carousel owl-theme wow mask-right">
                    <img src="images/logo-light/agrovech-logo.webp" class="w-100 px-4" alt="">
                    <img src="images/logo-light/ataunilogobeyaz.png" class="w-100 px-4" alt="">
                    <img src="images/logo-light/BV_Logo_WS-3.png" class="w-100 px-4" alt="">
                    <img src="images/logo-light/doruklogo.png" class="w-100 px-4" alt="">
                    <img src="images/logo-light/enda-otomasyon-seeklogo.png" class="w-100 px-4" alt="">
                    <img src="images/logo-light/gto-2.png" class="w-100 px-4" alt="">
                    <img src="images/logo-light/gtu_logo_tr.webp" class="w-100 px-4" alt="">
                    <img src="images/logo-light/hacıbayramveliüni.png" class="w-100 px-4" alt="">
                    <img src="images/logo-light/omron-logocopy.png" class="w-100 px-4" alt="">
                    <img src="images/logo-light/pt-beyaz.png" class="w-100 px-4" alt="">
                    <img src="images/logo-light/teknoder-beyaz.png" class="w-100 px-4" alt="">
                    <img src="images/logo-light/TR-beyaz_yatay_logo .png" class="w-100 px-4" alt="">
                </div>
            </div>
        </div>
    </div>
</section>


<section id="section-tickets" class="bg-dark section-dark text-light pt-80 relative jarallax" aria-label="section">
    <img src="images/background/4.webp" class="jarallax-img" alt="">
    <div class="gradient-edge-top"></div>
    <div class="gradient-edge-bottom"></div>
    <div class="sw-overlay op-5"></div>

    <div class="container relative z-2">
        <div class="row g-4 gx-5 justify-content-center">
            <div class="col-lg-6 text-center">
                <h2 class="wow fadeInUp" data-wow-delay=".2s">Danışmanlık Hizmetlerimiz</h2>
            </div>
        </div>

        <div class="row g-4 justify-content-center">
            <div class="col-lg-12">
                <?php
                $danismanlik_onay = 1;

                $sorgu_danismanlik = "SELECT * FROM danismanlik 
    INNER JOIN danismanlik_dil ON danismanlik_id = danismanlikdil_danismanlik_id 
    WHERE danismanlik_onay = :onay 
      AND danismanlik_userfirm_id = :basekayit
    ORDER BY danismanlik_eklenme_tarihi DESC
    LIMIT 6";

                $stmt = $connPDO->prepare($sorgu_danismanlik);
                $stmt->bindParam(':onay', $danismanlik_onay, PDO::PARAM_INT);
                $stmt->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
                $stmt->execute();

                $danismanliklar = $stmt->fetchAll(PDO::FETCH_ASSOC);
                ?>



                <?php if (!empty($danismanliklar)): ?>
                    <div class="owl-carousel owl-theme owl-2-dots owl-nav-visible">
                        <?php foreach(array_slice($danismanliklar, 0, 6) as $danismanlik): ?>
                            <div class="item">
                                <div class="relative overflow-hidden border-white-op-3 rounded-1 bg-blur" style="height: 420px; display: flex; flex-direction: column; justify-content: space-between;">
                                    <div class="gradient-edge-bottom color op-5"></div>
                                    <div class="p-40 relative z-2" style="flex: 1; display: flex; flex-direction: column; justify-content: space-between;">
                                        <div class="text-center">
                                            <h2 class="fs-40 mb-0"><?= htmlspecialchars($danismanlik['danismanlikdil_sayfaad']); ?></h2>
                                        </div>
                                        <div class="border-white-bottom-op-2 mb-4"></div>
                                        <div style="flex: 1; overflow: hidden;">
                                            <p style="margin-bottom: 20px;">
                                                <?= nl2br(htmlspecialchars(substr($danismanlik['danismanlikdil_metni'], 0, 200))); ?>...
                                            </p>
                                        </div>
                                        <a class="btn-main fx-slide w-100" href="<?= $base_url . $danismanlik['danismanlikdil_sayfaurl']; ?>">
                                            <span>Danışmanlığa Git</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="text-center mt-4">
                        <a href="<?= $base_url ?>danismanlik" class="btn-main btn-line">
                            Tüm Danışmanlıkları Gör
                        </a>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <h4>Danışmanlıklarımız çok yakında burada yer alacaktır.</h4>
                    </div>
                <?php endif; ?>


            </div>
        </div>
    </div>
</section>
<!-- jQuery -->
<script src="path-to/jquery.min.js"></script>

<!-- Owl Carousel -->
<script src="path-to/owl.carousel.min.js"></script>
<?php
include('sabitsayfalar/footer.php');
?>
<script>
    $(document).ready(function(){
        $(".owl-carousel").owlCarousel({
            items: 3,
            loop: false,
            margin: 30,
            nav: true,
            dots: true,
            navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
            responsive: {
                0: { items: 1 },
                768: { items: 2 },
                992: { items: 3 }
            }
        });
    });
</script>

